﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Net.Sockets;
using System.Net;

namespace Asteroid
  {
  class Program
    {
    static void Main(string[] args)
      {
      PlayerKI player = null;
      IPAddress ipadress = null;
      bool bRunOnce = true;

      Console.Clear();

      do
        {
        if (args.Length == 1)
          {
          Console.Title = String.Format(Properties.Resources.strTitle, args[0]);
          if (IPAddress.TryParse(args[0], out ipadress))
            {
            try
              {
              player = new PlayerKI(ipadress, 1979);
              player.Run();
              }
            catch (Exception exp)
              {
              Console.WriteLine(exp.Message);
              Console.WriteLine(Properties.Resources.strContiuneToExit);
              Console.ReadKey();
              }
            }
          else
            {
            try
              {
              player = new PlayerKI(args[0], 1979);
              player.Run();
              }
            catch (Exception exp)
              {
              Console.WriteLine(exp.Message);
              Console.WriteLine(Properties.Resources.strInvalidIP, args[0]);
              Console.WriteLine(Properties.Resources.strContiuneToExit);
              Console.ReadKey();
              }
            }
          }
        else
          {
          Console.WriteLine(Properties.Resources.strInvalidArgumentCount);
          Console.WriteLine(Properties.Resources.strContiuneToExit);
          Console.ReadKey();
          }
        if (player != null)
          bRunOnce = player.RunOnce;
        }
      while (!bRunOnce);
      }
    }
  }
